/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWException;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWProcess;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWWorkObject;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminTrackerDataObject;
import filenet.vw.toolkit.admin.result.VWAdminWorkObjectTableData;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.util.Vector;

public class VWAdminDataObjForTrackers {
    private VWAdminWorkObjectTableData m_woData;
    private VWWorkObject m_wob;
    private Vector m_vTrackers = new Vector();
    private String m_wobNumber;
    private VWParticipant m_logonUser;
    private VWSession m_session = null;

    public VWAdminDataObjForTrackers(VWAdminWorkObjectTableData woData, VWParticipant logonUser, VWSession session) {
        try {
            this.m_woData = woData;
            this.m_wob = woData.getWob();
            this.m_wobNumber = this.m_wob.getWorkObjectNumber();
            this.m_logonUser = logonUser;
            this.m_session = session;
            this.buildTrackerList();
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
    }

    protected String getName() {
        return this.m_wobNumber;
    }

    protected Vector getTrackers() {
        return this.m_vTrackers;
    }

    protected VWAdminWorkObjectTableData getWoData() {
        return this.m_woData;
    }

    private void buildTrackerList() {
        VWWorkObject wob = null;
        Vector<VWAdminWorkObjectTableData> v_children = new Vector<VWAdminWorkObjectTableData>();
        try {
            if (v_children != null) {
                v_children.removeAllElements();
            }
            VWProcess proc = this.m_wob.fetchProcess();
            while (proc.hasNext()) {
                wob = proc.next();
                if (wob == null) continue;
                VWAdminWorkObjectTableData dataField = new VWAdminWorkObjectTableData(wob, this.m_logonUser, false, -1, -1);
                v_children.addElement(dataField);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        if (v_children.size() == 0) {
            return;
        }
        for (int i = 0; i < v_children.size(); ++i) {
            VWAdminWorkObjectTableData childWOData = (VWAdminWorkObjectTableData)v_children.elementAt(i);
            wob = childWOData.getWob();
            if (wob == null) continue;
            try {
                VWQueue queue = this.m_session.getQueue(wob.getCurrentQueueName());
                if (!wob.getIsTracker() || wob.getParticipantName() == null || VWStringUtils.compare(wob.getParticipantName(), "(NONE)") == 0 || queue.getQueueType() == 3) continue;
                VWAdminTrackerDataObject trackerInfo = new VWAdminTrackerDataObject(childWOData);
                this.m_vTrackers.addElement(trackerInfo);
                continue;
            }
            catch (VWException ex) {
                VWDebug.logException(ex);
            }
        }
    }
}

